<?php
session_start();
include('./partials/config/config.php');
//login 
if (isset($_POST['login'])) {
    $user_email = $_POST['email'];
    $user_password = sha1(md5($_POST['password'])); //double encrypt to increase security
    $stmt = $mysqli->prepare("SELECT email, password, id  FROM tbl_employees WHERE (email =? AND password =?)"); //sql to log in user
    $stmt->bind_param('ss',  $user_email, $user_password); //bind fetched parameters
    $stmt->execute(); //execute bind 
    $stmt->bind_result($user_email, $user_password, $id); //bind result
    $rs = $stmt->fetch();
    $_SESSION['user_id'] = $id;
    if ($rs) {
        //if its sucessfull
        $success = "Login Successful" && header("refresh:1; url=index.php");
    } else {
        $err = "Incorrect login credentials" && header("refresh:1; url=signin.php");
    }
}
?>


<!DOCTYPE html>
<html lang="en">

<?php require_once './partials/_head.php' ?>

<body class="account-page">

    <div class="main-wrapper">
        <div class="account-content">
            <div class="login-wrapper">
                <div class="login-content">
                    <form action="" role="form" method="post">

                        <div class="login-userset">
                            <div class="login-logo">
                                <img src="assets/img/logo.png" alt="img">
                            </div>
                            <div class="login-userheading">
                                <h3>Sign In</h3>
                                <h4>Please login to your account</h4>
                            </div>
                            <div class="form-login">
                                <label>Email</label>
                                <div class="form-addons">
                                    <input type="text" name="email" placeholder="Enter your email address" required>
                                    <img src="assets/img/icons/mail.svg" alt="img">
                                </div>
                            </div>
                            <div class="form-login">
                                <label>Password</label>
                                <div class="pass-group">
                                    <input type="password" name="password" class="pass-input" placeholder="Enter your password" required>
                                    <span class="fas toggle-password fa-eye-slash"></span>
                                </div>
                            </div>
                            <div class="form-login">
                                <div class="alreadyuser">
                                    <h4><a href="forgetpassword.php" class="hover-a">Forgot Password?</a></h4>
                                </div>
                            </div>
                            <div class="form-login">
                                <button class="btn btn-login" type="submit" name="login">Login</button>
                            </div>
                            <div class="signinform text-center">
                                <h4>Don’t have an account? <a href="signup.php" class="hover-a">Sign Up</a></h4>
                            </div>
                            <div class="form-setlogin">
                                <h4>Or sign up with</h4>
                            </div>
                            <div class="form-sociallink">
                                <ul>
                                    <li>
                                        <a href="javascript:void(0);">
                                            <img src="assets/img/icons/google.png" class="me-2" alt="google">
                                            Sign Up using Google
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);">
                                            <img src="assets/img/icons/facebook.png" class="me-2" alt="google">
                                            Sign Up using Facebook
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                    </form>

                </div>
                <div class="login-img">
                    <img src="assets/img/login.png" alt="img">
                </div>
            </div>
        </div>
    </div>

    <?php require_once './partials/_scripts.php' ?>
</body>

</html>