<?php
session_start();
include('./partials/config/config.php');
include('./partials/config/checklogin.php');
include('./partials/config/code-generator.php');


// verbose debugging
ini_set('display_startup_errors', 1);
ini_set('display_errors', 1);
error_reporting(-1);


if (isset($_POST['register'])) {
    //Prevent Posting Blank Values
    if (empty($_POST["code"]) || empty($_POST["fname"]) || empty($_POST['email'])) {
        $err = "Blank Values Not Accepted";
    } else {
        $id = $mpesaCode;
        $code  = $_POST['code'];
        $fname = $_POST['fname'];
        $lname = $_POST['lname'];
        $gender = $_POST['gender'];
        $email = $_POST['email'];
        $phone = $_POST['phone'];
        $country = $_POST['country'];
        $state = $_POST['state'];
        $town = $_POST['town'];
        $role = $_POST['role'];
        $department = $_POST['department'];
        $designation = $_POST['designation'];
        $address = $_POST['address'];
        $description = $_POST['desc'];
        $idno = $_POST['idno'];
        $dob = $_POST['dob'];
        $doj = $_POST['doj'];
        $salary = $_POST['salary'];

        $status = "active";

        $otp1 = $mpesaCode . $beta;

        $staff_id = "1";

        $created_at = date("Y-m-d H:i:s");


        // We need to check if the account with that email exists
        if ($stmt = $mysqli->prepare('SELECT id, password FROM tbl_employees WHERE email = ?')) {
            // user with the email address is found on the database
            $stmt->bind_param('s', $_POST['email']);
            $stmt->execute();
            $stmt->store_result();
            // Store the result so we can check if the account exists in the database.
            if ($stmt->num_rows > 0) {
                $err = "Email Already Exists";
                header("refresh:1; url=register.php");
            } else {
                //Insert Captured information to a database table
                $postQuery = "INSERT INTO tbl_employees (id, code, fname, lname, gender, email, phone, country, state, town, department, designation, address, description, idno, role, status, dob, doj, salary, created_at, otp1) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                $postStmt = $mysqli->prepare($postQuery);
                //bind paramaters
                $rc = $postStmt->bind_param('ssssssssssssssssssssss', $id, $code, $fname, $lname, $gender, $email, $phone, $country, $state, $town, $department, $designation, $address, $description, $idno, $role, $status, $dob, $doj, $salary, $created_at, $otp1);
                $postStmt->execute();
                //declare a varible which will be passed to alert function
                if ($postStmt) {
                    $_SESSION['verify_email'] = $email;
                    $_SESSION['verify_code'] = $otp1;

                    header("refresh:1; url=mailer.php");
                } else {
                    $err = "Please Try Again Or Try Later";
                }
            }
        } else {
            $err = "Please Try Again Or Try Later";
        }
    }
}

?>


<!DOCTYPE html>
<html lang="en">

<?php require_once './partials/_head.php' ?>

<body>
    <div class="main-wrapper">

        <?php require_once './partials/_header.php' ?>
        <?php require_once './partials/_sidebar.php' ?>

        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>Users Management</h4>
                        <h6>Add User</h6>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <form action="" method="post">
                            <div class="row">
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Employee Code</label>
                                        <input type="text" name="code" readonly value="EMP-<?php echo $beta; ?>" required>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>First Name</label>
                                        <input type="text" required name="fname">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Last Name</label>
                                        <input type="text" name="lname" required>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Gender</label>
                                        <select class="form-control" name="gender" required>
                                            <option value="">----</option>
                                            <option value='female'>Female</option>
                                            <option value='male'>Male</option>

                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Email</label>
                                        <input class="form-control" type="email" name="email" required>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Phone</label>
                                        <input class="form-control" type="tel" name="phone" required>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Country</label>
                                        <input type="text" name="country" required>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>State</label>
                                        <input type="text" name="state" required>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Town</label>
                                        <input type="text" name="town" required>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Choose Department</label>
                                        <select class="form-control" name="department" required>
                                            <option value="">----</option>
                                            <?php
                                            $get_dep = "SELECT * FROM tbl_departments ORDER BY `tbl_departments`.`name` ASC";
                                            $run_dep = mysqli_query($mysqli, $get_dep);

                                            while ($row_dep = mysqli_fetch_array($run_dep)) {
                                                $dep_id = $row_dep['id'];
                                                $name = $row_dep['name'];

                                                echo "<option value='$dep_id'>$name</option>";
                                            }
                                            ?>

                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Choose Designation</label>
                                        <select class="form-control" name="designation" required>
                                            <option value="">----</option>
                                            <?php
                                            $get_des = "SELECT * FROM tbl_designations ORDER BY `tbl_designations`.`name` ASC";
                                            $run_des = mysqli_query($mysqli, $get_des);

                                            while ($row_des = mysqli_fetch_array($run_des)) {
                                                $des_id = $row_des['id'];
                                                $name = $row_des['name'];

                                                echo "<option value='$des_id'>$name</option>";
                                            }
                                            ?>

                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Choose Role</label>
                                        <select class="form-control" name="role" required>
                                            <option value="">----</option>
                                            <?php
                                            $get_rol = "SELECT * FROM tbl_roles ORDER BY `tbl_roles`.`name` ASC";
                                            $run_rol = mysqli_query($mysqli, $get_rol);

                                            while ($row_rol = mysqli_fetch_array($run_rol)) {
                                                $rol_id = $row_rol['id'];
                                                $name = $row_rol['name'];

                                                echo "<option value='$rol_id'>$name</option>";
                                            }
                                            ?>

                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-12 col-12">
                                    <div class="form-group">
                                        <label>Address</label>
                                        <input type="text" name="address" required>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Staff Description</label>
                                        <textarea name="desc" required class="form-control"></textarea>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>National ID </label>
                                        <input type="text" name="idno" required>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Date Of Birth </label>
                                        <input type="date" name="dob" class="form-control" required>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Joining Date </label>
                                        <input type="date" class="form-control" name="doj" required>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Salary </label>
                                        <input type="number" class="form-control" name="salary" required>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <button type="submit" name="register" class="btn btn-primary">Register User</button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php require_once './partials/_scripts.php' ?>
</body>

</html>