<?php
session_start();
include('./partials/config/config.php');
include('./partials/config/checklogin.php');

require_once('./partials/analytics.php');

check_login();
?>


<!DOCTYPE html>
<html lang="en">

<?php require_once './partials/_head.php' ?>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">

        <?php require_once './partials/_header.php' ?>
        <?php require_once './partials/_sidebar.php' ?>

        <div class="page-wrapper">

            <div class="container m-2">
                <div class="row">
                    <div class="col-md-6">
                        <h5>Welcome, JEFF</h5>
                        <p>You have <strong class="text-green">3</strong> Court Hearings Today</p>
                    </div>
                </div>

            </div>

            <div class="content">
                <div class="row">
                    <div class="col-lg-3 col-sm-6 col-12">
                        <div class="dash-widget">
                            <div class="dash-widgetimg">
                                <span><img src="assets/img/icons/excel.svg" alt="img"></span>
                            </div>
                            <div class="dash-widgetcontent">
                                <h5><span class="counters" data-count="30">30</span></h5>
                                <h6>Cases</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6 col-12">
                        <div class="dash-widget dash1">
                            <div class="dash-widgetimg">
                                <span><img src="assets/img/icons/users1.svg" alt="img"></span>
                            </div>
                            <div class="dash-widgetcontent">
                                <h5><span class="counters" data-count="25">25</span></h5>
                                <h6>Clients</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6 col-12">
                        <div class="dash-widget dash2">
                            <div class="dash-widgetimg">
                                <span><img src="assets/img/icons/excel.svg" alt="img"></span>
                            </div>
                            <div class="dash-widgetcontent">
                                <h5><span class="counters" data-count="4"> 4</span></h5>
                                <h6>Case Study</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6 col-12">
                        <div class="dash-widget dash3">
                            <div class="dash-widgetimg">
                                <span><img src="assets/img/icons/users1.svg" alt="img"></span>
                            </div>
                            <div class="dash-widgetcontent">
                                <h5><span class="counters" data-count="7"> 7</span></h5>
                                <h6>Employees</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6 col-12 d-flex">
                        <div class="dash-count">
                            <div class="dash-counts">
                                <h4>10</h4>
                                <h5>Appointments</h5>
                            </div>
                            <div class="dash-imgs">
                                <i data-feather="file-text"></i>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6 col-12 d-flex">
                        <div class="dash-count das1">
                            <div class="dash-counts">
                                <h4>6</h4>
                                <h5>Events</h5>
                            </div>
                            <div class="dash-imgs">
                                <i data-feather="calendar"></i>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6 col-12 d-flex">
                        <div class="dash-count das2">
                            <div class="dash-counts">
                                <h4>100</h4>
                                <h5>Paid Invoice</h5>
                            </div>
                            <div class="dash-imgs">
                                <i data-feather="file-text"></i>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6 col-12 d-flex">
                        <div class="dash-count das3">
                            <div class="dash-counts">
                                <h4>105</h4>
                                <h5>Total Invoice</h5>
                            </div>
                            <div class="dash-imgs">
                                <i data-feather="file"></i>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-7 col-sm-12 col-12 d-flex">
                        <div class="card flex-fill">
                            <div class="card-header pb-0 d-flex justify-content-between align-items-center">
                                <h5 class="card-title mb-0">Active & Archived Cases</h5>
                                <div class="graph-sets">
                                    <ul>
                                        <li>
                                            <span>Active</span>
                                        </li>
                                        <li>
                                            <span>Archived</span>
                                        </li>
                                    </ul>
                                    <div class="dropdown">
                                        <button class="btn btn-white btn-sm dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                                            2025 <img src="assets/img/icons/dropdown.svg" alt="img" class="ms-2">
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                            <li>
                                                <a href="javascript:void(0);" class="dropdown-item">2025</a>
                                            </li>
                                            <li>
                                                <a href="javascript:void(0);" class="dropdown-item">2024</a>
                                            </li>
                                            <li>
                                                <a href="javascript:void(0);" class="dropdown-item">2023</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div id="sales_charts"></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 col-sm-12 col-12 d-flex">
                        <div class="card flex-fill">
                            <div class="card-header pb-0 d-flex justify-content-between align-items-center">
                                <h4 class="card-title mb-0">Latest Cases</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive dataview">
                                    <table class="table datatable ">
                                        <thead>
                                            <tr>
                                                <th>Title</th>
                                                <th>Case No</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>GOI vs Cardbury</td>
                                                <td>C0023</td>
                                                <td>View</td>
                                            </tr>
                                            <tr>
                                                <td>GOI vs West millan</td>
                                                <td>C0022</td>
                                                <td>View</td>
                                            </tr>
                                            <tr>
                                                <td>GovKE vs TESTBN</td>
                                                <td>C0021</td>
                                                <td>View</td>
                                            </tr>
                                            <tr>
                                                <td>TestBN Vs Millan</td>
                                                <td>C0020</td>
                                                <td>View</td>
                                            </tr>
                                            <tr>
                                                <td>Jeff Mathea vs Cardbury</td>
                                                <td>C0019</td>
                                                <td>View</td>
                                            </tr>
                                            <tr>
                                                <td>Afc Vs Gor Mahia</td>
                                                <td>C0018</td>
                                                <td>View</td>
                                            </tr>
                                            <tr>
                                                <td>West code Vs Safaricom</td>
                                                <td>C0017</td>
                                                <td>View</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card mb-0">
                    <div class="card-body">
                        <h4 class="card-title">Clients</h4>
                        <div class="table-responsive dataview">
                            <table class="table datatable ">
                                <thead>
                                    <tr>
                                        <th>SNo</th>
                                        <th>Code</th>
                                        <th>First Name</th>
                                        <th>Contact</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td><a href="javascript:void(0);">IT0001</a></td>
                                        <td class="productimgname">
                                            <a href="productlist.php">Mercy</a>
                                        </td>
                                        <td>254713501753</td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-7 col-sm-12 col-12 d-flex">
                        <div class="card flex-fill">
                            <div class="card-header pb-0 d-flex justify-content-between align-items-center">
                                <h5 class="card-title mb-0">Net Profit & Revenue</h5>

                            </div>
                            <div class="card-body">
                                <div id="s-col" class="chart-set"></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 col-sm-12 col-12 d-flex">
                        <div class="card flex-fill">
                            <div class="card-header pb-0 d-flex justify-content-between align-items-center">
                                <h4 class="card-title mb-0">To Do Tasks</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive dataview">
                                    <table class="table datatable ">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Title</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>23/02/2026 12:00 p.m</td>
                                                <td>Client Meet</td>
                                                <td><span class="badges btn-primary">View</span></td>
                                            </tr>
                                            <tr>
                                                <td>01/02/2026 12:00 p.m</td>
                                                <td>Collect Payment</td>
                                                <td><span class="badges btn-primary">View</span></td>
                                            </tr>
                                            <tr>
                                                <td>12/02/2026 12:00 p.m</td>
                                                <td>Call Client</td>
                                                <td><span class="badges btn-primary">View</span></td>
                                            </tr>
                                            <tr>
                                                <td>11/02/2026 12:00 p.m</td>
                                                <td>Test</td>
                                                <td><span class="badges btn-primary">View</span></td>
                                            </tr>
                                            <tr>
                                                <td>09/02/2026 12:00 p.m</td>
                                                <td>Back Up system</td>
                                                <td><span class="badges btn-primary">View</span></td>
                                            </tr>
                                            <tr>
                                                <td>01/02/2026 12:00 p.m</td>
                                                <td>Collect Payment</td>
                                                <td><span class="badges btn-primary">View</span></td>
                                            </tr>
                                            <tr>
                                                <td>12/02/2026 12:00 p.m</td>
                                                <td>Call Client</td>
                                                <td><span class="badges btn-primary">View</span></td>
                                            </tr>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <h5>Recent Transactions</h5>

                <div class="card">
                    <div class="card-body">
                        <div class="tabs-set">
                            <ul class="nav nav-tabs" id="myTab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="purchase-tab" data-bs-toggle="tab" data-bs-target="#purchase" type="button" role="tab" aria-controls="purchase" aria-selected="true">Income</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="payment-tab" data-bs-toggle="tab" data-bs-target="#payment" type="button" role="tab" aria-controls="payment" aria-selected="false">Expenses</button>
                                </li>

                            </ul>
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active" id="purchase" role="tabpanel" aria-labelledby="purchase-tab">
                                    <div class="table-top">
                                        <div class="search-set">
                                            <div class="search-path">
                                                <a class="btn btn-filter" id="filter_search">
                                                    <img src="assets/img/icons/filter.svg" alt="img">
                                                    <span><img src="assets/img/icons/closes.svg" alt="img"></span>
                                                </a>
                                            </div>
                                            <div class="search-input">
                                                <a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
                                            </div>
                                        </div>
                                        <div class="wordset">
                                            <ul>
                                                <li>
                                                    <a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
                                                </li>
                                                <li>
                                                    <a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
                                                </li>
                                                <li>
                                                    <a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="card" id="filter_inputs">
                                        <div class="card-body pb-0">
                                            <div class="row">
                                                <div class="col-lg-2 col-sm-6 col-12">
                                                    <div class="form-group">
                                                        <div class="input-groupicon">
                                                            <input type="text" placeholder="From Date" class="datetimepicker">
                                                            <div class="addonset">
                                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-2 col-sm-6 col-12">
                                                    <div class="form-group">
                                                        <div class="input-groupicon">
                                                            <input type="text" placeholder="To Date" class="datetimepicker">
                                                            <div class="addonset">
                                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-1 col-sm-6 col-12 ms-auto">
                                                    <div class="form-group">
                                                        <a class="btn btn-filters ms-auto"><img src="assets/img/icons/search-whites.svg" alt="img"></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="table-responsive">
                                        <table class="table datanew">
                                            <thead>
                                                <tr>
                                                    <th>
                                                        <label class="checkboxs">
                                                            <input type="checkbox">
                                                            <span class="checkmarks"></span>
                                                        </label>
                                                    </th>
                                                    <th>Client</th>
                                                    <th>Invoice Number</th>
                                                    <th>Address</th>
                                                    <th>Paid</th>
                                                    <th>balance</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>
                                                        <label class="checkboxs">
                                                            <input type="checkbox">
                                                            <span class="checkmarks"></span>
                                                        </label>
                                                    </td>
                                                    <td>Waweru</td>
                                                    <td>CLN23222</td>
                                                    <td>1248</td>
                                                    <td>0.00</td>
                                                    <td>38698.00</td>
                                                    <td><span class="badges bg-lightgrey">Recieved</span></td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <label class="checkboxs">
                                                            <input type="checkbox">
                                                            <span class="checkmarks"></span>
                                                        </label>
                                                    </td>
                                                    <td>Njau</td>

                                                    <td>CLN23232</td>
                                                    <td>110</td>
                                                    <td>0.00</td>
                                                    <td>36080.00</td>
                                                    <td><span class="badges bg-lightgrey">Recieved</span></td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="payment" role="tabpanel">
                                    <div class="table-top">
                                        <div class="search-set">
                                            <div class="search-path">
                                                <a class="btn btn-filter" id="filter_search2">
                                                    <img src="assets/img/icons/filter.svg" alt="img">
                                                    <span><img src="assets/img/icons/closes.svg" alt="img"></span>
                                                </a>
                                            </div>
                                            <div class="search-input">
                                                <a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
                                            </div>
                                        </div>
                                        <div class="wordset">
                                            <ul>
                                                <li>
                                                    <a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
                                                </li>
                                                <li>
                                                    <a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
                                                </li>
                                                <li>
                                                    <a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="card" id="filter_inputs2">
                                        <div class="card-body pb-0">
                                            <div class="row">
                                                <div class="col-lg-2 col-sm-6 col-12">
                                                    <div class="form-group">
                                                        <div class="input-groupicon">
                                                            <input type="text" placeholder="From Date" class="datetimepicker">
                                                            <div class="addonset">
                                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-2 col-sm-6 col-12">
                                                    <div class="form-group">
                                                        <div class="input-groupicon">
                                                            <input type="text" placeholder="To Date" class="datetimepicker">
                                                            <div class="addonset">
                                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-1 col-sm-6 col-12 ms-auto">
                                                    <div class="form-group">
                                                        <a class="btn btn-filters ms-auto"><img src="assets/img/icons/search-whites.svg" alt="img"></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="table-responsive">
                                        <table class="table datanew">
                                            <thead>
                                                <tr>
                                                    <th>
                                                        <label class="checkboxs">
                                                            <input type="checkbox">
                                                            <span class="checkmarks"></span>
                                                        </label>
                                                    </th>
                                                    <th>DATE</th>
                                                    <th>Title</th>
                                                    <th>Amount</th>
                                                    <th>Staff </th>
                                                    <th>paid by</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>
                                                        <label class="checkboxs">
                                                            <input type="checkbox">
                                                            <span class="checkmarks"></span>
                                                        </label>
                                                    </td>
                                                    <td>2022-03-10 </td>
                                                    <td>Printer Purchase</td>
                                                    <td>10000</td>
                                                    <td>Thomas21</td>
                                                    <td><span class="badges bg-lightgrey">Approved</span></td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <label class="checkboxs">
                                                            <input type="checkbox">
                                                            <span class="checkmarks"></span>
                                                        </label>
                                                    </td>
                                                    <td>2022-03-10 </td>
                                                    <td>PR_1002</td>
                                                    <td>INV/PR_1002</td>
                                                    <td>504Benjamin</td>
                                                    <td><span class="badges bg-lightgrey">Completed</span></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php require_once './partials/_scripts.php' ?>
</body>

</html>