<?php
session_start();
include('./partials/config/config.php');
include('./partials/config/checklogin.php');
include('./partials/config/code-generator.php');

require_once('./partials/analytics.php');

check_login();


if (isset($_POST['addaccount'])) {
    //Prevent Posting Blank Values
    if (empty($_POST["account"]) || empty($_POST["opening"]) || empty($_POST['hname'])) {
        $err = "Blank Values Not Accepted";
    } else {
        $id = $mpesaCode;
        $bank = $_POST['bank'];
        $holder_name = $_POST['hname'];
        $account = $_POST['account'];
        $type = $_POST['type'];
        $opening = $_POST['opening'];
        $notes = $_POST['notes'];

        $staff_id = $_SESSION['user_id'];

        $created_at = date("Y-m-d H:i:s");

        //Insert Captured information to a database table
        $postQuery = "INSERT INTO tbl_bank_accounts (id, bank, holder_name, account, type, opening_bal, notes, created_at, staff_id) VALUES(?,?,?,?,?,?,?,?,?)";
        $postStmt = $mysqli->prepare($postQuery);
        //bind paramaters
        $rc = $postStmt->bind_param('sssssssss', $id, $bank, $holder_name, $account, $type, $opening, $notes, $created_at, $staff_id);
        $postStmt->execute();
        //declare a varible which will be passed to alert function
        if ($postStmt) {

            $success = "Bank Account Added" && header("refresh:1; url=financialsettings.php");
        } else {
            $err = "Please Try Again Or Try Later";
        }
    }
}


?>

<!DOCTYPE html>
<html lang="en">

<?php require_once './partials/_head.php' ?>

<body>
    <div class="main-wrapper">

        <?php require_once './partials/_header.php' ?>
        <?php require_once './partials/_sidebar.php' ?>

        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>Financial Settings</h4>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <h5 style="font-weight: bold;">Payment gateways</h5>

                            <div class="col-lg-6 col-sm-6 col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <button type="button" class="btn btn-outline-dark">Not Connected</button>
                                        <h5 class="card-title">Lipa na Mpesa</h5>
                                        <p class="card-text">Safaricom is Simple, transparent and honest.</p>
                                        <a href="#" class="btn btn-primary">View Integration</a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-6 col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <button type="button" class="btn btn-outline-dark">Not Connected</button>
                                        <h5 class="card-title">Paypal</h5>
                                        <p class="card-text">PayPal is the faster, safer way to send and receive money.</p>
                                        <a href="#" class="btn btn-primary">View Integration</a>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="page-header m-2 p-2">
                        <div class="page-title">
                            <h4>Bank Accounts</h4>
                        </div>
                        <div class="input-groupicon">
                            <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#addaccount">Add Bank Account</button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">

                            <div class="col-lg-6 col-sm-6 col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title">Kenya Commercial Bank</h5>
                                        <p class="card-text">**** **** **** 2536</p>

                                        <p>Card Holder</p>
                                        <h5 class="card-text">Brian Wafula</h5>
                                        <a href="#" class="btn btn-primary">Edit</a>
                                        <a href="#" class="btn btn-danger">Delete</a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-6 col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title">Kenya Commercial Bank</h5>
                                        <p class="card-text">**** **** **** 2536</p>

                                        <p>Card Holder</p>
                                        <h5 class="card-text">Brian Wafula</h5>
                                        <a href="#" class="btn btn-primary">Edit</a>
                                        <a href="#" class="btn btn-danger">Delete</a>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="page-header m-2 p-2">
                        <div class="page-title">
                            <h4>Tax Rates</h4>
                        </div>
                        <div class="page-btn">
                            <a href="addtax rate.php" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img">Add Tax Rate</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-top">
                            <div class="search-set">
                                <div class="search-path">
                                    <a class="btn btn-filter" id="filter_search">
                                        <img src="assets/img/icons/filter.svg" alt="img">
                                        <span><img src="assets/img/icons/closes.svg" alt="img"></span>
                                    </a>
                                </div>
                                <div class="search-input">
                                    <a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
                                </div>
                            </div>
                            <div class="wordset">
                                <ul>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table datanew">
                                <thead>
                                    <tr>
                                        <th>
                                            <label class="checkboxs">
                                                <input type="checkbox" id="select-all">
                                                <span class="checkmarks"></span>
                                            </label>
                                        </th>
                                        <th>sn</th>
                                        <th>Tax Name</th>
                                        <th>Tax Rates</th>
                                        <th>Created On</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <label class="checkboxs">
                                                <input type="checkbox">
                                                <span class="checkmarks"></span>
                                            </label>
                                        </td>
                                        <td class="productimgname">
                                            <a href="javascript:void(0);">SDSD</a>
                                        </td>
                                        <td>Sprays</td>
                                        <td>Sprays</td>
                                        <td>Sprays</td>
                                        <td>
                                            <a class="me-3" href="editsupplier.php">
                                                <img src="assets/img/icons/edit.svg" alt="img">
                                            </a>
                                            <a class="me-3 confirm-text" href="javascript:void(0);">
                                                <img src="assets/img/icons/delete.svg" alt="img">
                                            </a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <?php require_once './partials/_scripts.php' ?>

    <!-- modal section -->

    <div class="modal fade" id="addaccount" tabindex="-1" aria-labelledby="addproduct" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Bank Account</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                </div>
                <div class="modal-body">
                    <form action="" role="form" method="post">
                        <div class="row">

                            <div class="col-lg-4 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Bank</label>
                                    <input type="text" name="bank" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Holder Name</label>
                                    <input class="form-control" name="hname" type="text" required>
                                </div>
                            </div>

                            <div class="col-lg-4 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Account</label>
                                    <input class="form-control" name="account" type="number" required>
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Type</label>
                                    <select name="type" class="form-control" required id="">
                                        <option value="">-----</option>
                                        <option value="Savings">Savings</option>
                                        <option value="Current Account">Current Account</option>
                                        <option value="Salary Account">Salary Account</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Opening Balance</label>
                                    <input class="form-control" name="opening" type="number" required>
                                </div>
                            </div>

                            <div class="col-lg-12 col-sm-6 col-12">
                                <div class="form-group">
                                    <textarea name="notes" required id=""></textarea>
                                </div>
                            </div>

                            <div class="col-lg-12 col-sm-6 col-12">
                                <div class="form-group">
                                    <button type="submit" name="addaccount" class="btn btn-submit">ADD</button>
                                </div>
                            </div>

                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>

</body>

</html>