<?php
session_start();
include('./partials/config/config.php');
include('./partials/config/checklogin.php');

require_once('./partials/analytics.php');

check_login();
?>

<!DOCTYPE html>
<html lang="en">

<?php require_once './partials/_head.php' ?>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">

        <?php require_once './partials/_header.php' ?>
        <?php require_once './partials/_sidebar.php' ?>

        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>Edit Customer Management</h4>
                        <h6>Edit/Update Customer</h6>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-3 col-sm-6 col-12">
                                <div class="form-group">
                                    <label>Customer Name</label>
                                    <input type="text" value="Thomas">
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6 col-12">
                                <div class="form-group">
                                    <label>Email</label>
                                    <input type="text" value="Thomas@example.com">
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6 col-12">
                                <div class="form-group">
                                    <label>Phone</label>
                                    <input type="text" value="+12163547758 ">
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6 col-12">
                                <div class="form-group">
                                    <label>Choose County</label>
                                    <select class="form-control">
                                        <option>Homabay</option>
                                        <option>Migori</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6 col-12">
                                <div class="form-group">
                                    <label>Town</label>
                                    <select class="form-control">
                                        <option>Migori</option>
                                        <option>Rongo</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6 col-12">
                                <div class="form-group">
                                    <label>Company Type</label>
                                    <select class="form-control">
                                        <option>Individual</option>
                                        <option>Company</option>
                                        <option>Partnership</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6 col-12">
                                <div class="form-group">
                                    <label>Billing Currency</label>
                                    <select class="form-control">
                                        <option>KES</option>
                                        <option>USD</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6 col-12">
                                <div class="form-group">
                                    <label>Default Bank Account</label>
                                    <input type="text" class="select">
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6 col-12">
                                <div class="form-group">
                                    <label>Credit Limit</label>
                                    <input type="text" class="select">
                                </div>
                            </div>
                            <div class="col-lg-9 col-12">
                                <div class="form-group">
                                    <label>Address</label>
                                    <input type="text" value="2323, Rodi, Homabay, Kenya ">
                                </div>
                            </div>
                            <div class="col-lg-6 col-12">
                                <div class="form-group">
                                    <input type="checkbox" id="termsAgree" name="terms" value="agree">
                                    <label for="termsAgree">Allow sales invoice creation without sales order</a></label>
                                </div>
                            </div>
                            <div class="col-lg-6 col-12">
                                <div class="form-group">
                                    <input type="checkbox" id="termsAgree" name="terms" value="agree">
                                    <label for="termsAgree">Allow sales invoice creation without Delivery Note</a></label>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label>Description</label>
                                    <textarea class="form-control">Lorem Ipsumnd yard dummy text </textarea>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <a class="btn btn-submit me-2">Update</a>
                                <a class="btn btn-cancel">Cancel</a>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <?php require_once './partials/_scripts.php' ?>
</body>

</html>