<?php
session_start();
include('./partials/config/config.php');
include('./partials/config/checklogin.php');
include('./partials/config/code-generator.php');

check_login();


if (isset($_POST['adddesignation'])) {
    //Prevent Posting Blank Values
    if (empty($_POST["code"]) || empty($_POST["name"]) || empty($_POST['desc'])) {
        $err = "Blank Values Not Accepted";
    } else {
        $id = $mpesaCode;
        $code  = $_POST['code'];
        $name = $_POST['name'];
        $desc = $_POST['desc'];

        $staff_id = "1";

        $created_at = date("Y-m-d H:i:s");

        //Insert Captured information to a database table
        $postQuery = "INSERT INTO tbl_designations (id, code, name, description, created_at, staff_id) VALUES(?,?,?,?,?,?)";
        $postStmt = $mysqli->prepare($postQuery);
        //bind paramaters
        $rc = $postStmt->bind_param('ssssss', $id, $code, $name, $desc, $created_at, $staff_id);
        $postStmt->execute();
        //declare a varible which will be passed to alert function
        if ($postStmt) {

            $success = "Departments Added" && header("refresh:1; url=designations.php");
        } else {
            $err = "Please Try Again Or Try Later";
        }
    }
}

?>


<!DOCTYPE html>
<html lang="en">

<?php require_once './partials/_head.php' ?>

<body>

    <div class="main-wrapper">

        <?php require_once './partials/_header.php' ?>
        <?php require_once './partials/_sidebar.php' ?>

        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>DESIGNATIONS</h4>
                        <h6>Manage your Designations</h6>
                    </div>
                    <div class="input-groupicon">
                        <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#adddesignation">Add Designation</button>
                    </div>
                </div>

                <div class="card">

                    <div class="card-body">
                        <div class="table-top">
                            <div class="search-set">
                                <div class="search-path">
                                    <a class="btn btn-filter" id="filter_search">
                                        <img src="assets/img/icons/filter.svg" alt="img">
                                        <span><img src="assets/img/icons/closes.svg" alt="img"></span>
                                    </a>
                                </div>
                                <div class="search-input">
                                    <a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
                                </div>
                            </div>
                            <div class="wordset">
                                <ul>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table datanew">
                                <thead>
                                    <tr>
                                        <th>
                                            <label class="checkboxs">
                                                <input type="checkbox" id="select-all">
                                                <span class="checkmarks"></span>
                                            </label>
                                        </th>
                                        <th>Designation</th>
                                        <th>Department</th>
                                        <th>Total Members</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <label class="checkboxs">
                                                <input type="checkbox">
                                                <span class="checkmarks"></span>
                                            </label>
                                        </td>
                                        <td class="productimgname">
                                            <a href="javascript:void(0);">Apex Computers</a>
                                        </td>
                                        <td>201</td>
                                        <td>+12163547758 </td>
                                        <td>China</td>
                                        <td>
                                            <a class="me-3" href="editsupplier.php">
                                                <img src="assets/img/icons/edit.svg" alt="img">
                                            </a>
                                            <a class="me-3 confirm-text" href="javascript:void(0);">
                                                <img src="assets/img/icons/delete.svg" alt="img">
                                            </a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <?php require_once './partials/_scripts.php' ?>

    <!-- modal section -->

    <div class="modal fade" id="adddesignation" tabindex="-1" aria-labelledby="addproduct" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Create Desiganation</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                </div>
                <div class="modal-body">
                    <form action="" method="post">
                        <div class="row">

                            <div class="col-lg-6 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Designation Code</label>
                                    <input type="text" name="code" value="DES-<?php echo $beta; ?>" readonly class="form-control" required>
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input type="text" name="name" required>
                                </div>
                            </div>

                            <div class="col-lg-12 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Description</label>
                                    <textarea name="desc" id="" required></textarea>
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6 col-12">
                                <div class="form-group">
                                    <button type="submit" name="adddesignation" class="btn btn-submit">ADD</button>
                                </div>
                            </div>

                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>


</body>

</html>