<?php
session_start();
include('./partials/config/config.php');
include('./partials/config/checklogin.php');
include('./partials/config/code-generator.php');

require_once('./partials/analytics.php');

check_login();


if (isset($_POST['addattorney'])) {
    //Prevent Posting Blank Values
    if (empty($_POST["fname"]) || empty($_POST["email"]) || empty($_POST['hdate'])) {
        $err = "Blank Values Not Accepted";
    } else {
        $id = $mpesaCode;
        $fname = $_POST['fname'];
        $lname = $_POST['lname'];
        $city = $_POST['city'];
        $town = $_POST['town'];
        $phone = $_POST['phone'];
        $email = $_POST['email'];
        $bar_number = $_POST['barno'];
        $hire_date = $_POST['hdate'];
        $speciality = $_POST['speciality'];
        $status = "active";

        $staff_id = $_SESSION['user_id'];

        $created_at = date("Y-m-d H:i:s");

        //Insert Captured information to a database table
        $postQuery = "INSERT INTO tbl_attorneys (id, fname, lname, city, town, phone, email, bar_number, hire_date, speciality, status, created_at, staff_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)";
        $postStmt = $mysqli->prepare($postQuery);
        //bind paramaters
        $rc = $postStmt->bind_param('sssssssssssss', $id, $fname, $lname, $city, $town, $phone, $email, $bar_number, $hire_date, $speciality, $status, $created_at, $staff_id);
        $postStmt->execute();
        //declare a varible which will be passed to alert function
        if ($postStmt) {

            $success = "Attorney Added" && header("refresh:1; url=appointments.php");
        } else {
            $err = "Please Try Again Or Try Later";
        }
    }
}


?>


<!DOCTYPE html>
<html lang="en">

<?php require_once './partials/_head.php' ?>

<body>

    <div class="main-wrapper">

        <?php require_once './partials/_header.php' ?>
        <?php require_once './partials/_sidebar.php' ?>

        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>Attorneys</h4>
                        <h6>Manage Attorneys</h6>
                    </div>
                    <div class="input-groupicon">
                        <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#addattorney">Add Attorney</button>
                    </div>
                </div>

                <div class="card">

                    <div class="card-body">
                        <div class="table-top">
                            <div class="search-set">
                                <div class="search-path">
                                    <a class="btn btn-filter" id="filter_search">
                                        <img src="assets/img/icons/filter.svg" alt="img">
                                        <span><img src="assets/img/icons/closes.svg" alt="img"></span>
                                    </a>
                                </div>
                                <div class="search-input">
                                    <a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
                                </div>
                            </div>
                            <div class="wordset">
                                <ul>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table datanew">
                                <thead>
                                    <tr>
                                        <th>
                                            <label class="checkboxs">
                                                <input type="checkbox" id="select-all">
                                                <span class="checkmarks"></span>
                                            </label>
                                        </th>
                                        <th>sn</th>
                                        <th>First Name</th>
                                        <th>Contact</th>
                                        <th>Speciality</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <label class="checkboxs">
                                                <input type="checkbox">
                                                <span class="checkmarks"></span>
                                            </label>
                                        </td>
                                        <td class="productimgname">
                                            <a href="javascript:void(0);">SDSD</a>
                                        </td>
                                        <td>Sprays</td>
                                        <td>Sprays</td>
                                        <td>Sprays</td>
                                        <td>
                                            <a class="me-3" href="editsupplier.php">
                                                <img src="assets/img/icons/edit.svg" alt="img">
                                            </a>
                                            <a class="me-3 confirm-text" href="javascript:void(0);">
                                                <img src="assets/img/icons/delete.svg" alt="img">
                                            </a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php require_once './partials/_scripts.php' ?>


    <!-- modal section -->

    <div class="modal fade" id="addattorney" tabindex="-1" aria-labelledby="addproduct" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Attorney</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                </div>
                <div class="modal-body">
                    <form action="" role="form" method="post">
                        <div class="row">

                            <div class="col-lg-4 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>First Name</label>
                                    <input type="text" name="fname" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Last Name</label>
                                    <input class="form-control" name="lname" type="text" required>
                                </div>
                            </div>

                            <div class="col-lg-4 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>City</label>
                                    <input class="form-control" name="city" type="text" required>
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Town</label>
                                    <input class="form-control" name="town" type="text" required>
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Email Address</label>
                                    <input class="form-control" name="email" type="email" required>
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Phone Number</label>
                                    <input class="form-control" name="phone" type="text" required>
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Bar Number</label>
                                    <input class="form-control" name="barno" type="text" required>
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Hire Date</label>
                                    <input class="form-control" name="hdate" type="date" required>
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Speciality</label>
                                    <input class="form-control" name="speciality" type="text" required>
                                </div>
                            </div>

                            <div class="col-lg-3 col-sm-6 col-12">
                                <div class="form-group">
                                    <button type="submit" name="addattorney" class="btn btn-submit">ADD</button>
                                </div>
                            </div>

                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>

</body>

</html>